//
//  HNSShapeView.m
//  HNSAppKit
//
//  Created by Dr. H. Nikolaus Schaller on Thu Apr 03 2003.
//  Copyright (c) 2003 __MyCompanyName__. All rights reserved.
//

#import "HNSShapeView.h"

@implementation HNSShapeCell

@end

@implementation HNSShapeView

- (id)initWithFrame:(NSRect)frame
{
    self=[super initWithFrame:frame];
    if(self)
		{
        // Initialization code here.
		}
    return self;
}

- (void)drawRect:(NSRect)rect
{
	NSRect myBounds=[self bounds];
	if(backgroundColor)
		{
		[backgroundColor set];
		[NSBezierPath fillRect:myBounds];	// draw background
		}
	if(image)
		{ // draw image
		}
	if(path && (strokeColor || fillColor))
		{ // draw shape
		NSAffineTransform *t=[NSAffineTransform transform];	// allocate temporary
		NSBezierPath *p;
		[t translateXBy:0.0 yBy:myBounds.size.height];				// flip coordinates and
		[t scaleXBy:myBounds.size.width yBy:-myBounds.size.height];	// scale to full size of object
		// rotation should be done by rotating ObjectView itself (because of clipping)
		// set attributes of obj
  // border
   // background
   // shape
   // line/arrows
		p=[t transformBezierPath:path];
		if(strokeColor)
			{
			[strokeColor set];
			[p stroke];
			}
		if(fillColor)
			{ // not disabled
			[fillColor set];
			[p fill];
			}
		if(boxColor)
			{ // draw box
			[boxColor set];			// should use box color
								 // set stroke width&style
			[NSBezierPath strokeRect:myBounds];	// draw box
			}
		}
	[super drawRect:rect];	// finally draw any other text
}

@end
